unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,Microsoft.Win32;



type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    Button2: System.Windows.Forms.Button;
    Button3: System.Windows.Forms.Button;
    Button4: System.Windows.Forms.Button;
    CheckBox1: System.Windows.Forms.CheckBox;
    Button5: System.Windows.Forms.Button;
    Button7: System.Windows.Forms.Button;
    Button8: System.Windows.Forms.Button;
    Button9: System.Windows.Forms.Button;
    GroupBox1: System.Windows.Forms.GroupBox;
    GroupBox2: System.Windows.Forms.GroupBox;
    GroupBox3: System.Windows.Forms.GroupBox;
    GroupBox4: System.Windows.Forms.GroupBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
    procedure Button4_Click(sender: System.Object; e: System.EventArgs);
    procedure CheckBox1_CheckedChanged(sender: System.Object; e: System.EventArgs);
    procedure Button5_Click(sender: System.Object; e: System.EventArgs);
    procedure Button7_Click(sender: System.Object; e: System.EventArgs);
    procedure Button9_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
    function CzytajUstawieniaOkna(okno: TWinForm; klucz: String):Boolean;
    function ZapiszUstawieniaOkna(okno: TWinForm; klucz: String):Boolean;
    function KonfigurujAutostart(nazwa: String; plikExe: String; czynnosc: integer):Boolean;
    procedure RozszerzMenuKontekstowe(rozszerzenie, polecenie, opis: String);
    
  private
    { Private Declarations }
  public
    constructor Create;
  end;

 type TDodajUsunInfo = record
  DisplayName, DisplayIcon, DisplayVersion,
  Contact, Publisher, Comments, URLUpdateInfo, URLInfoAbout,
  InstallLocation, InstallSource, ProductID,
  UninstallString, UninstallPath, ModifyPath,
  Readme, HelpLink, HelpTelephone,
  RegCompany, RegOwner, LogFile :String;
  VersionMajor, VersionMinor,
  NoRemove, NoRepair, Language :Integer;
  end;

 function KonfigurujDodajUsun(nazwaKlucza :String; rekord :TDodajUsunInfo; czynnosc :integer) :Boolean;
 function CzyIstniejeZapisDodajUsun(nazwaKlucza :String) :Boolean;


implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.Button3 := System.Windows.Forms.Button.Create;
  Self.Button4 := System.Windows.Forms.Button.Create;
  Self.Button5 := System.Windows.Forms.Button.Create;
  Self.Button8 := System.Windows.Forms.Button.Create;
  Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
  Self.GroupBox2 := System.Windows.Forms.GroupBox.Create;
  Self.CheckBox1 := System.Windows.Forms.CheckBox.Create;
  Self.GroupBox3 := System.Windows.Forms.GroupBox.Create;
  Self.GroupBox4 := System.Windows.Forms.GroupBox.Create;
  Self.Button7 := System.Windows.Forms.Button.Create;
  Self.Button9 := System.Windows.Forms.Button.Create;
  Self.GroupBox2.SuspendLayout;
  Self.GroupBox3.SuspendLayout;
  Self.GroupBox4.SuspendLayout;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(24, 32);
  Self.Button1.Name := 'Button1';
  Self.Button1.Size := System.Drawing.Size.Create(90, 26);
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Odczytaj';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(24, 64);
  Self.Button2.Name := 'Button2';
  Self.Button2.Size := System.Drawing.Size.Create(90, 26);
  Self.Button2.TabIndex := 1;
  Self.Button2.Text := 'Zapisz';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // Button3
  // 
  Self.Button3.Location := System.Drawing.Point.Create(10, 28);
  Self.Button3.Name := 'Button3';
  Self.Button3.Size := System.Drawing.Size.Create(90, 26);
  Self.Button3.TabIndex := 2;
  Self.Button3.Text := 'Zapisz';
  Include(Self.Button3.Click, Self.Button3_Click);
  // 
  // Button4
  // 
  Self.Button4.Location := System.Drawing.Point.Create(106, 28);
  Self.Button4.Name := 'Button4';
  Self.Button4.Size := System.Drawing.Size.Create(90, 26);
  Self.Button4.TabIndex := 3;
  Self.Button4.Text := 'Usu';
  Include(Self.Button4.Click, Self.Button4_Click);
  // 
  // Button5
  // 
  Self.Button5.Location := System.Drawing.Point.Create(16, 28);
  Self.Button5.Name := 'Button5';
  Self.Button5.Size := System.Drawing.Size.Create(90, 26);
  Self.Button5.TabIndex := 5;
  Self.Button5.Text := 'Dodaj';
  Include(Self.Button5.Click, Self.Button5_Click);
  // 
  // Button8
  // 
  Self.Button8.Location := System.Drawing.Point.Create(106, 24);
  Self.Button8.Name := 'Button8';
  Self.Button8.Size := System.Drawing.Size.Create(90, 26);
  Self.Button8.TabIndex := 8;
  Self.Button8.Text := 'Usu';
  Include(Self.Button8.Click, Self.Button7_Click);
  // 
  // GroupBox1
  // 
  Self.GroupBox1.Location := System.Drawing.Point.Create(8, 8);
  Self.GroupBox1.Name := 'GroupBox1';
  Self.GroupBox1.Size := System.Drawing.Size.Create(125, 96);
  Self.GroupBox1.TabIndex := 10;
  Self.GroupBox1.TabStop := False;
  Self.GroupBox1.Text := 'Ustawienia okna';
  // 
  // GroupBox2
  // 
  Self.GroupBox2.Controls.Add(Self.CheckBox1);
  Self.GroupBox2.Controls.Add(Self.Button3);
  Self.GroupBox2.Controls.Add(Self.Button4);
  Self.GroupBox2.Location := System.Drawing.Point.Create(144, 8);
  Self.GroupBox2.Name := 'GroupBox2';
  Self.GroupBox2.Size := System.Drawing.Size.Create(212, 96);
  Self.GroupBox2.TabIndex := 11;
  Self.GroupBox2.TabStop := False;
  Self.GroupBox2.Text := 'Autostart';
  // 
  // CheckBox1
  // 
  Self.CheckBox1.Location := System.Drawing.Point.Create(10, 56);
  Self.CheckBox1.Name := 'CheckBox1';
  Self.CheckBox1.Size := System.Drawing.Size.Create(182, 27);
  Self.CheckBox1.TabIndex := 5;
  Self.CheckBox1.Text := 'Uruchom automatycznie';
  Include(Self.CheckBox1.CheckedChanged, Self.CheckBox1_CheckedChanged);
  // 
  // GroupBox3
  // 
  Self.GroupBox3.Controls.Add(Self.Button5);
  Self.GroupBox3.Location := System.Drawing.Point.Create(8, 112);
  Self.GroupBox3.Name := 'GroupBox3';
  Self.GroupBox3.Size := System.Drawing.Size.Create(125, 72);
  Self.GroupBox3.TabIndex := 12;
  Self.GroupBox3.TabStop := False;
  Self.GroupBox3.Text := 'Menu Kontekst.';
  // 
  // GroupBox4
  // 
  Self.GroupBox4.Controls.Add(Self.Button7);
  Self.GroupBox4.Controls.Add(Self.Button9);
  Self.GroupBox4.Controls.Add(Self.Button8);
  Self.GroupBox4.Location := System.Drawing.Point.Create(144, 112);
  Self.GroupBox4.Name := 'GroupBox4';
  Self.GroupBox4.Size := System.Drawing.Size.Create(212, 104);
  Self.GroupBox4.TabIndex := 13;
  Self.GroupBox4.TabStop := False;
  Self.GroupBox4.Text := 'Dodaj/Usu programy';
  // 
  // Button7
  // 
  Self.Button7.Location := System.Drawing.Point.Create(10, 24);
  Self.Button7.Name := 'Button7';
  Self.Button7.Size := System.Drawing.Size.Create(90, 26);
  Self.Button7.TabIndex := 10;
  Self.Button7.Text := 'Dodaj';
  Include(Self.Button7.Click, Self.Button7_Click);
  // 
  // Button9
  // 
  Self.Button9.Location := System.Drawing.Point.Create(10, 64);
  Self.Button9.Name := 'Button9';
  Self.Button9.Size := System.Drawing.Size.Create(184, 26);
  Self.Button9.TabIndex := 9;
  Self.Button9.Text := 'Czy istnieje?';
  Include(Self.Button9.Click, Self.Button9_Click);
  // 
  // TWinForm
  // 
  Self.AutoScale := False;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(6, 15);
  Self.ClientSize := System.Drawing.Size.Create(360, 224);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.Button1);
  Self.Controls.Add(Self.GroupBox1);
  Self.Controls.Add(Self.GroupBox2);
  Self.Controls.Add(Self.GroupBox3);
  Self.Controls.Add(Self.GroupBox4);
  Self.Name := 'TWinForm';
  Self.Text := 'Rejestr (Windows Forms)';
  Include(Self.Closing, Self.TWinForm_Closing);
  Include(Self.Load, Self.TWinForm_Load);
  Self.GroupBox2.ResumeLayout(False);
  Self.GroupBox3.ResumeLayout(False);
  Self.GroupBox4.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

function CzyIstniejeZapisDodajUsun(nazwaKlucza :String) :Boolean;
var rekord :TDodajUsunInfo;
begin
Result:=KonfigurujDodajUsun(nazwaKlucza,rekord,1);
end;

function KonfigurujDodajUsun(nazwaKlucza :String; rekord :TDodajUsunInfo; czynnosc :integer) :Boolean;
const Klucz='Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall';
var rejestr: RegistryKey;
    kluczAplikacji: String;
    kluczaplikacjiistnieje: boolean;
begin
rejestr:=Registry.LocalMachine.OpenSubKey(Klucz);
if rejestr<> nil then
  begin
  KluczAplikacji:=Klucz+'\\'+nazwaklucza;
  rejestr:=Registry.LocalMachine.OpenSubKey(KluczAplikacji,true);

  if rejestr<>nil then
    kluczaplikacjiistnieje:=true
    else
    kluczaplikacjiistnieje:=false;

  if czynnosc=1 then
    begin
    result:=kluczaplikacjiistnieje;
    if kluczaplikacjiistnieje then rejestr.Close;
    exit;
    end;

  if kluczaplikacjiistnieje then
    case czynnosc of
    1:
      begin
      Result:=KluczAplikacjiistnieje;
      rejestr.Close;
      exit;
      end;
    2:
      begin
      Result:=false;
      exit;
      end;
    3:
      begin
      Registry.LocalMachine.DeleteSubKey(KluczAplikacji);
      Result:=true;
      rejestr.close;
      exit;
      end;
    end;

  if czynnosc=2 then
  begin
  rejestr:=Registry.LocalMachine.CreateSubKey(KluczAplikacji);
  if rejestr<> nil then
    begin
      if rekord.DisplayName<>'' then rejestr.SetValue('DisplayName',rekord.DisplayName)
        else
        raise Exception.Create('Pole "DisplayName" musi zawiera naw aplikacji');
      if rekord.UninstallString<>'' then rejestr.SetValue('UninstallString',rekord.UninstallString)
        else raise Exception.Create('Pole "UninstalString" musi zawiera cierzk do instalatora aplikacji');
      if rekord.DisplayIcon<>'' then rejestr.SetValue('DisplayIcon',rekord.DisplayIcon);
      if rekord.DisplayVersion<>'' then rejestr.SetValue('DisplayVersion',rekord.DisplayVersion);
      if rekord.Contact<>'' then rejestr.SetValue('Contact',rekord.Contact);
      if rekord.Publisher<>'' then rejestr.SetValue('Publisher',rekord.Publisher);
      if rekord.Comments<>'' then rejestr.SetValue('Comments',rekord.Comments);
      if rekord.URLUpdateInfo<>'' then rejestr.SetValue('URLUpdateInfo',rekord.URLUpdateInfo);
      if rekord.URLInfoAbout<>'' then rejestr.SetValue('UrlInfoAbout',rekord.URLInfoAbout);
      if rekord.InstallLocation<>'' then rejestr.SetValue('InstallLocation',rekord.InstallLocation);
      if rekord.InstallSource<>'' then rejestr.SetValue('InstallSource',rekord.InstallSource);
      if rekord.ProductID<>'' then rejestr.SetValue('ProductID',rekord.ProductID);
      if rekord.UninstallPath<>'' then rejestr.SetValue('UninstallPath',rekord.UninstallPath);
      if rekord.ModifyPath<>'' then rejestr.SetValue('ModifyPath',rekord.ModifyPath);
      if rekord.Readme<>'' then rejestr.SetValue('Readme',rekord.Readme);
      if rekord.HelpLink<>'' then rejestr.SetValue('HelpLink',rekord.HelpLink);
      if rekord.HelpTelephone<>'' then rejestr.SetValue('HelpTelephon',rekord.HelpTelephone);
      if rekord.RegCompany<>'' then rejestr.SetValue('RegCompany',rekord.RegCompany);
      if rekord.RegOwner<>'' then rejestr.SetValue('RegOwner',rekord.RegOwner);
      if rekord.LogFile<>'' then rejestr.SetValue('LogFile',rekord.LogFile);
      if rekord.VersionMajor<>-1 then rejestr.SetValue('VersionMajor',rekord.VersionMajor);
      if rekord.VersionMinor<>-1 then rejestr.SetValue('VersionMinor',rekord.VersionMinor);
      if rekord.NoRemove<>-1 then rejestr.SetValue('NoRemove',rekord.NoRemove);
      if rekord.NoRepair<>-1 then rejestr.SetValue('NoRepair',rekord.NoRepair);
      if rekord.Language<>-1 then rejestr.SetValue('Language',rekord.Language);
      Result:=true;
      rejestr.Close;
    end
    else
    raise Exception.Create('Klucz nie moe by stworzony lub otwarty');
  end;
end;
end;
procedure TWinForm.RozszerzMenuKontekstowe(rozszerzenie, polecenie, opis: String);
begin

end;

function TWinForm.KonfigurujAutostart(nazwa: String; plikExe: String; czynnosc: integer):Boolean;
const klucz='Software\\Microsoft\\Windows\\CurrentVersion\\Run';
var rejestr: RegistryKey;
begin
try
rejestr:=Registry.CurrentUser.OpenSubKey(klucz,true);
case czynnosc of
1: if rejestr.GetValue(nazwa)<>nil then result:=true;
2: rejestr.SetValue(nazwa,plikexe);
3: rejestr.DeleteValue(nazwa);
end;
except
MessageBox.Show('Nie mona otworzy klucza!!!');
Result:=false;
end;
rejestr.Close;
rejestr:=nil;
end;

function TWinForm.CzytajUstawieniaOkna(okno: TWinForm; klucz: String):Boolean;
var rejestr: RegistryKey;
begin
rejestr:=Registry.CurrentUser.OpenSubKey(klucz);
if rejestr=nil then
  begin
    rejestr:=Registry.CurrentUser.CreateSubKey(klucz);
    Result:=false;
    exit;
  end
else
  begin
    if rejestr.GetValue('Left')<>nil then
    okno.Left:=System.Convert.ToInt32(rejestr.GetValue('Left'));
    if rejestr.GetValue('Top')<>nil then
    okno.Top:= System.Convert.ToInt32(rejestr.GetValue('Top'));
    if rejestr.GetValue('Height')<>nil then
    okno.Height:=System.Convert.ToInt32(rejestr.GetValue('Height'));
    if rejestr.GetValue('Width')<>nil then
    okno.Width:=System.Convert.ToInt32(rejestr.GetValue('Width'));
    rejestr.Close;
    Result:=true;
  end
end;

function TwinForm.ZapiszUstawieniaOkna(okno: TWinForm; klucz: String):Boolean;
var rejestr: RegistryKey;
begin
rejestr:=Registry.CurrentUser.OpenSubKey(klucz,true);
if rejestr=nil then
begin
  try
    rejestr:=Registry.CurrentUser.CreateSubKey(klucz);
  except
    Result:=false;
    exit;
  end;
end;
rejestr.SetValue('Left',okno.Left);
rejestr.SetValue('Top',okno.Top);
rejestr.SetValue('Height',okno.Height);
rejestr.SetValue('Width',okno.Width);
rejestr.Close;
end;

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.Button9_Click(sender: System.Object; e: System.EventArgs);
var TakNie :String;
begin
TakNie:='nie ';
if CzyIstniejeZapisDodajUsun('Projekt1') then TakNie:='';
MessageBox.Show ('Klucz Dodaj/Usu '+TakNie+'istnieje');
end;

procedure TWinForm.Button7_Click(sender: System.Object; e: System.EventArgs);
var DodajUsun: TDodajUsunInfo;
begin
with DodajUsun do
begin
  DisplayName:='Projekt1';
  UninstallString:=Application.get_ExecutablePath+'/uninstall';
  DisplayIcon:=Application.get_ExecutablePath;
  DisplayVersion:='1.0';
  Contact:='bigman@phys.uni.torun.pl';
  Publisher:='Helion';
  Comments:='Delphi 2005. 101 praktycznych przykadw';
  URLUpdateInfo:='http://www.phys.uni.torun.pl/~bigman/';
  URLInfoAbout:='http://helion.pl';
  InstallLocation:=Application.get_ExecutablePath;
  InstallSource:=Environment.get_CurrentDirectory;
  UninstallPath:=Application.get_ExecutablePath+' /uninstall';
  ModifyPath:=Application.get_ExecutablePath+' /modify';
  HelpLink:='http://www.phys.uni.torun.pl/~bigman/';
  VersionMajor:=1;
  VersionMinor:=0;
  NoRepair:=1;
  Language:=-1;
end;
if Sender=Button7 then
begin
 try
 MessageBox.Show('Tworz klucz: '+DodajUsun.DisplayName);
 KonfigurujDodajUsun('Projekt1',DodajUsun,2);
except
  on exc: Exception do MessageBox.Show(exc.ToString);
end;
end;
if Sender=Button8 then
begin
 try
  MessageBox.Show('Usuwam klucz: '+DodajUsun.DisplayName);
  KonfigurujDodajUsun('Projekt1',DodajUsun,3);
 except
  on exc: Exception do MessageBox.Show(exc.ToString);
end;
end;
end;

procedure TWinForm.Button5_Click(sender: System.Object; e: System.EventArgs);
begin
  RozszerzMenuKontekstowe('rtf','edit','edytuj w Projekt1');
end;

procedure TWinForm.CheckBox1_CheckedChanged(sender: System.Object; e: System.EventArgs);
begin
  if checkBox1.Checked then
  KonfigurujAutostart('Aplikacja',Application.ExecutablePath,2);


end;

procedure TWinForm.Button4_Click(sender: System.Object; e: System.EventArgs);
begin
 KonfigurujAutostart('Aplikacja','',3);
end;

procedure TWinForm.Button3_Click(sender: System.Object; e: System.EventArgs);

begin
 KonfigurujAutostart('Aplikacja',Application.ExecutablePath,2);
end;

procedure TWinForm.TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  Self.ZapiszUstawieniaOkna(Self,'Software\\Helion\\Przyklad\\Okno');
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  Self.CzytajUstawieniaOkna(Self,'Software\\Helion\\Przyklad\\Okno');
  checkbox1.Checked:=KonfigurujAutostart('Aplikacja','',1);
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  Self.ZapiszUstawieniaOkna(Self,'Software\\Helion\\Przyklad\\Okno');
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  Self.CzytajUstawieniaOkna(Self,'Software\\Helion\\Przyklad\\Okno');
end;

end.
